from flask import Flask, jsonify, request
from flask_cors import CORS

app = Flask(__name__)
CORS(app)  # pour autoriser les appels JS depuis un autre domaine

# Exemple: données simulées
dummy_data = {
    (2025, 6): {1: 2, 3: 1, 15: 5, 20: 7, 28: 3}
}

@app.route("/api/reservations")
def get_reservations():
    month = int(request.args.get("month"))
    year = int(request.args.get("year"))
    reservations = dummy_data.get((year, month), {})
    return jsonify(reservations)

if __name__ == "__main__":
    app.run(debug=True)
